using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Data.OleDb;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using System.Web.Security;
using System.Web.Mail;
using System.IO;


public class Master : System.Web.UI.MasterPage
{
	
	protected System.Web.UI.WebControls.Repeater Latest;
	protected System.Web.UI.WebControls.Repeater Blogroll;
	protected System.Web.UI.WebControls.Repeater Category;
	public string strCount;

	protected void Page_Load(object sender, System.EventArgs e) 
	{
	
	OleDbConnection conNewsData;
	OleDbCommand cmdSelectDB;
	OleDbDataReader dtrArticleData;
			
	conNewsData = new OleDbConnection( "PROVIDER=Microsoft.Jet.OLEDB.4.0;DATA Source=" + Server.MapPath("./NewsData.mdb") );
	conNewsData.Open();
	cmdSelectDB = new OleDbCommand( "Select TOP 5 * From ArticleData WHERE Hidden = 'No' ORDER BY ArticleId DESC", conNewsData );
	dtrArticleData = cmdSelectDB.ExecuteReader();
	Latest.DataSource = dtrArticleData;  
	Latest.DataBind(); 
	conNewsData.Close();

	DataSet objCategory = new DataSet();
	objCategory.ReadXml(MapPath("./category.xml"));
	Category.DataSource = objCategory;
	Category.DataBind();
		
	DataSet objBlogroll = new DataSet();
	objBlogroll.ReadXml(MapPath("./blogroll.xml"));
	Blogroll.DataSource = objBlogroll;
	Blogroll.DataBind(); 
			
	}
	
}


public class Default : System.Web.UI.Page
{

protected System.Web.UI.WebControls.Repeater Content;
protected System.Web.UI.WebControls.Label UserPanel;
protected System.Web.UI.WebControls.Label hdnArticleId;

	protected void Page_Load(object sender, System.EventArgs e) 
	{

			OleDbConnection conNewsData;
			OleDbCommand cmdSelectDB;
			OleDbDataReader dtrArticleData;
			
			conNewsData = new OleDbConnection( "PROVIDER=Microsoft.Jet.OLEDB.4.0;DATA Source=" + Server.MapPath("./NewsData.mdb") );
			conNewsData.Open();
			cmdSelectDB = new OleDbCommand( "Select * From ArticleData WHERE Hidden = 'No' ORDER BY ArticleId DESC", conNewsData );
			dtrArticleData = cmdSelectDB.ExecuteReader();
			Content.DataSource = dtrArticleData;  
			Content.DataBind(); 
			conNewsData.Close();
	
	}

}


public class Comments : System.Web.UI.Page
{


public int CommentNumber = 0;
protected System.Web.UI.WebControls.Label UserPanel;
protected System.Web.UI.WebControls.Repeater CommentRepeater;
protected System.Web.UI.WebControls.Repeater ArticleRepeater;
protected System.Web.UI.WebControls.TextBox CommentContent;
protected System.Web.UI.WebControls.TextBox UserName;
protected System.Web.UI.WebControls.Button Submit_Comment;
protected System.Web.UI.WebControls.Panel Open;
protected System.Web.UI.WebControls.Panel Locked;
protected System.Web.UI.WebControls.Panel Protected;
protected System.Web.UI.WebControls.Panel Respond;
protected System.Web.UI.WebControls.Label lblArticleComments;
protected System.Web.UI.WebControls.Label lblArticleName;



protected void Page_Load(object sender, System.EventArgs e) {
		if ( !IsPostBack ) {
			BindData();
	 	}	
		
		}
					 			
	 		private void BindData() {
	 		DataSet NewsDS = new DataSet();   
				
	 		OleDbConnection conNewsData = new OleDbConnection( "PROVIDER=Microsoft.Jet.OLEDB.4.0;DATA Source=" + Server.MapPath("./NewsData.mdb") );
   	 		OleDbCommand cmdSelectArticleDB = new OleDbCommand( "Select * FROM ArticleData WHERE ArticleId= @ArticleId", conNewsData );
	 		OleDbCommand cmdSelectCommentDB = new OleDbCommand( "Select * FROM CommentData WHERE CommentId= @CommentId ORDER BY CommentNumber ASC", conNewsData );
			
			cmdSelectArticleDB.Parameters.Add(new OleDbParameter("@ArticleId", Request.QueryString.Get("ArticleId")));
			cmdSelectCommentDB.Parameters.Add(new OleDbParameter("@CommentId", Request.QueryString.Get("ArticleId")));
			
			OleDbDataAdapter adpSelectDB = new OleDbDataAdapter();
			
	 		adpSelectDB.SelectCommand = cmdSelectArticleDB;
	 		adpSelectDB.Fill( NewsDS, "ArticleData" );
	
	 		adpSelectDB.SelectCommand = cmdSelectCommentDB;
	 		adpSelectDB.Fill( NewsDS, "CommentData" );
		
	 		NewsDS.Relations.Add( "ArticleComments", NewsDS.Tables["ArticleData"].Columns["ArticleName"], NewsDS.Tables["CommentData"].Columns["CommentName"] );
	 			
	 		ArticleRepeater.DataSource = NewsDS;
	 		ArticleRepeater.DataMember = "ArticleData";
	 		ArticleRepeater.DataBind();
			
			CommentRepeater.DataSource = NewsDS;
			CommentRepeater.DataMember = "CommentData";
			CommentRepeater.DataBind();
			
			string comProtection;
			string CommentProtection = "SELECT CommentProtection from ArticleData WHERE ArticleId = @ArticleId";
			OleDbCommand cmdCommentProtection = new OleDbCommand( CommentProtection, conNewsData );
			cmdCommentProtection.Parameters.Add(new OleDbParameter("@ArticleId", Request.QueryString.Get("ArticleId")));
			conNewsData.Open();
			Object objProtection = cmdCommentProtection.ExecuteScalar();
			comProtection = objProtection.ToString();
			conNewsData.Close();
			
		if ( comProtection == "Open")
			{
			Open.Visible = true;
			Locked.Visible = false;
			Protected.Visible = false;
			Respond.Visible = true;
			}
		
		else if ( comProtection == "Locked")
			{
			Open.Visible = false;
			Locked.Visible = true;
			Protected.Visible = false;
			Respond.Visible = false;
			}
			
		else if ( comProtection == "Protected")
			{
			Open.Visible = false;
			Locked.Visible = false;
			Protected.Visible = true;
			Respond.Visible = false;
			}
			
			
			string comArticleName;
			string ArticleName = "SELECT ArticleName from ArticleData WHERE ArticleId = @ArticleId";
			OleDbCommand cmdArticleName = new OleDbCommand( ArticleName, conNewsData );
			cmdArticleName.Parameters.Add(new OleDbParameter("@ArticleId", Request.QueryString.Get("ArticleId")));
			conNewsData.Open();
			Object objArticleName = cmdArticleName.ExecuteScalar();
			comArticleName = objArticleName.ToString();
			conNewsData.Close();
			lblArticleName.Text = comArticleName;
			
			string comArticleComments;
			string ArticleComments = "SELECT ArticleComments from ArticleData WHERE ArticleId = @ArticleId";
			OleDbCommand cmdArticleComments = new OleDbCommand( ArticleComments, conNewsData );
			cmdArticleComments.Parameters.Add(new OleDbParameter("@ArticleId", Request.QueryString.Get("ArticleId")));
			conNewsData.Open();
			Object objArticleComments = cmdArticleComments.ExecuteScalar();
			comArticleComments = objArticleComments.ToString();
			conNewsData.Close();
			lblArticleComments.Text = comArticleComments;
			
	 	}
		
		public void subcomButton_Click(object sender , System.EventArgs e) 
		{
		if (CommentContent.Text != "") {
		FormsIdentity objUserIdentity;
  		FormsAuthenticationTicket objTicket;
		DateTime Timestamp = DateTime.Now;
		string timeData = Timestamp.ToString( "G" ) + " CST";
		string comUserName;
		if (User.Identity.IsAuthenticated)
			{
				objUserIdentity = (FormsIdentity)User.Identity;
				objTicket = (FormsAuthenticationTicket)objUserIdentity.Ticket;
				comUserName = objUserIdentity.Name.ToString();
			}
			else
			{
				comUserName = "Guest";
			}
		string comIP = Request.UserHostAddress.ToString();
		string comContent = CommentContent.Text;
		string comId = Request.QueryString.Get("ArticleId");
		string comName = Request.QueryString.Get("ArticleName");
		string QueryArticleId = Request.QueryString.Get("ArticleId");
		string comNumber;
		string comTotal;
		string artLastUser;
		string artName;
		string comBrowser = Request.Browser.Browser + "  " + Request.Browser.Version;
		
		OleDbConnection conNewsData = new OleDbConnection( "PROVIDER=Microsoft.Jet.OLEDB.4.0;DATA Source=" + Server.MapPath("./NewsData.mdb") );
		string MaxComment = "SELECT MAX(CommentNumber) from CommentData WHERE CommentId = @CommentId";
		OleDbCommand cmdCommentNumber = new OleDbCommand( MaxComment, conNewsData );
		cmdCommentNumber.Parameters.Add(new OleDbParameter("@CommentId", Request.QueryString.Get("ArticleId")));
		conNewsData.Open();
		Object objMax = cmdCommentNumber.ExecuteScalar();
		if (objMax != DBNull.Value) {
			int intMax = Convert.ToInt32(objMax);
			comNumber = (intMax + 1).ToString();
			}
		else {
			comNumber = "1"; 
			}
		conNewsData.Close();

		
		string strInsert = "Insert Into CommentData ( CommentDate, CommentId, CommentContent, CommentUserName, CommentName, CommentNumber, IPAddress, BrowserType  ) Values (@timeData, @comId, @comContent, @comUserName, @comName, @comNumber, @comIP, @comBrowser)";	
		OleDbCommand cmdInsert = new OleDbCommand( strInsert, conNewsData );
		cmdInsert.Parameters.Add( "@timeData", timeData );
		cmdInsert.Parameters.Add( "@comId", comId );
		cmdInsert.Parameters.Add( "@comContent", comContent );
		cmdInsert.Parameters.Add( "@comUserName", comUserName );
		cmdInsert.Parameters.Add( "@comName", comName );
		cmdInsert.Parameters.Add( "@comNumber", comNumber );
		cmdInsert.Parameters.Add( "@comIP", comIP );
		cmdInsert.Parameters.Add( "@comBrowser", comBrowser );
		conNewsData.Open();
		cmdInsert.ExecuteNonQuery();
		conNewsData.Close();
		
		string TotalComment = "SELECT Count(CommentNumber) from CommentData WHERE CommentId = @CommentId";
		OleDbCommand cmdCommentTotal = new OleDbCommand( TotalComment, conNewsData );
		cmdCommentTotal.Parameters.Add(new OleDbParameter("@CommentId", Request.QueryString.Get("ArticleId")));
		conNewsData.Open();
		Object objTotal = cmdCommentTotal.ExecuteScalar();
		comTotal = objTotal.ToString();
		conNewsData.Close();
		
		string strUpdate = "UPDATE ArticleData SET ArticleComments = @Total WHERE ArticleId = @ArticleId";
		OleDbCommand cmdUpdateDB = new OleDbCommand( strUpdate, conNewsData );
		cmdUpdateDB.Parameters.Add(new OleDbParameter("@Total", comTotal));
		cmdUpdateDB.Parameters.Add(new OleDbParameter("@ArticleId", Request.QueryString.Get("ArticleId")));
		conNewsData.Open();
		cmdUpdateDB.ExecuteNonQuery();
		conNewsData.Close();
		
		string ArticleName = "SELECT ArticleName from ArticleData where ArticleId = @ArticleId";
		OleDbCommand cmdReadArticleName = new OleDbCommand( ArticleName, conNewsData );
		cmdReadArticleName.Parameters.Add(new OleDbParameter("@ArticleId", Request.QueryString.Get("ArticleId")));
		conNewsData.Open();
		Object objArticleName = cmdReadArticleName.ExecuteScalar();
		artName = objArticleName.ToString();
		conNewsData.Close();
		
		string LastComment = "SELECT CommentUserName from CommentData where CommentNumber = @Number AND CommentId = @CommentId";
		OleDbCommand cmdReadCommentDB = new OleDbCommand( LastComment, conNewsData );
		cmdReadCommentDB.Parameters.Add(new OleDbParameter("@Number", comNumber));
		cmdReadCommentDB.Parameters.Add(new OleDbParameter("@CommentId", Request.QueryString.Get("ArticleId")));
		conNewsData.Open();
		Object objLastComment = cmdReadCommentDB.ExecuteScalar();
		if (objLastComment != DBNull.Value) {
			artLastUser = "<a href='./Comments.aspx?ArticleId=" +  Request.QueryString.Get("ArticleId").ToString() + "&amp;ArticleName=" + artName + "#" + comTotal + "' class='ContentFooter'>Last comment</a> was by <a class='ContentFooterUser' href='#'>" + objLastComment.ToString() + "</a>";
			}
		else {
			artLastUser = "<a class='ContentFooter' href='./Comments.aspx?ArticleId=" + Request.QueryString.Get("ArticleId").ToString() + "&amp;ArticleName=" + artName + "'>Be the First to Submit a Comment</a>";
			}
	
		conNewsData.Close();
		
				
		string strUpdateLastUser = "UPDATE ArticleData SET LastComment = @LastComment WHERE ArticleId = @ArticleId";
		OleDbCommand cmdUpdateLastUserDB = new OleDbCommand( strUpdateLastUser, conNewsData );
		cmdUpdateLastUserDB.Parameters.Add(new OleDbParameter("@LastComment", artLastUser));
		cmdUpdateLastUserDB.Parameters.Add(new OleDbParameter("@ArticleId", Request.QueryString.Get("ArticleId")));
		conNewsData.Open();
		cmdUpdateLastUserDB.ExecuteNonQuery();
		conNewsData.Close();
		
		Response.Redirect(Request.UrlReferrer.ToString());
		}
		
		}

	}


public class Category : System.Web.UI.Page
{

protected System.Web.UI.WebControls.Repeater Content;
protected System.Web.UI.WebControls.Label UserPanel;
protected System.Web.UI.WebControls.Label hdnArticleId;

	protected void Page_Load(object sender, System.EventArgs e) {
			if ( !IsPostBack ) {
			BindRepeater();
	 		}			
	}	
	
	
	void BindRepeater (){
			OleDbConnection conNewsData;
			OleDbCommand cmdSelectDB;
			OleDbDataReader dtrArticleData;
			
			conNewsData = new OleDbConnection( "PROVIDER=Microsoft.Jet.OLEDB.4.0;DATA Source=" + Server.MapPath("./NewsData.mdb") );
			conNewsData.Open();
			cmdSelectDB = new OleDbCommand( "Select * From ArticleData WHERE Hidden = 'No' AND Category = @CatId ORDER BY ArticleId DESC", conNewsData );
			cmdSelectDB.Parameters.Add(new OleDbParameter("@CatId", Request.QueryString.Get("Category")));
			dtrArticleData = cmdSelectDB.ExecuteReader();
			Content.DataSource = dtrArticleData;  
			Content.DataBind();
			conNewsData.Close();
	}


}



public class rss : System.Web.UI.Page
{

protected System.Web.UI.WebControls.Repeater RSS;

protected void Page_Load(object sender , System.EventArgs e) 
		{
		
		OleDbConnection conNewsData;
		OleDbCommand cmdSelectDB;
		OleDbDataReader dtrArticleData;
			
		conNewsData = new OleDbConnection( "PROVIDER=Microsoft.Jet.OLEDB.4.0;DATA Source=" + Server.MapPath("./NewsData.mdb") );
		conNewsData.Open();
		cmdSelectDB = new OleDbCommand( "Select * From ArticleData WHERE Hidden = 'No' ORDER BY ArticleId DESC", conNewsData );
		dtrArticleData = cmdSelectDB.ExecuteReader();
		RSS.DataSource = dtrArticleData;  
		RSS.DataBind(); 
		conNewsData.Close();
		
		
		}
		
protected string FormatForXML(object input)
		{
  		string data = input.ToString();      // cast the input to a string

   		// replace those characters disallowed in XML documents
   		data = data.Replace("&", "&amp;");
   		data = data.Replace("\"", "&quot;");
   		data = data.Replace("'", "&apos;");
   		data = data.Replace("<", "&lt;");
   		data = data.Replace(">", "&gt;");

   		return data;
		}

}

public class Atom : System.Web.UI.Page
{

protected System.Web.UI.WebControls.Repeater ATOM;

protected void Page_Load(object sender , System.EventArgs e) 
		{
		
		OleDbConnection conNewsData;
		OleDbCommand cmdSelectDB;
		OleDbDataReader dtrArticleData;
			
		conNewsData = new OleDbConnection( "PROVIDER=Microsoft.Jet.OLEDB.4.0;DATA Source=" + Server.MapPath("./NewsData.mdb") );
		conNewsData.Open();
		cmdSelectDB = new OleDbCommand( "Select * From ArticleData WHERE Hidden = 'No' ORDER BY ArticleId DESC", conNewsData );
		dtrArticleData = cmdSelectDB.ExecuteReader();
		ATOM.DataSource = dtrArticleData;  
		ATOM.DataBind(); 
		conNewsData.Close();
		
		
		}
		
protected string FormatForXML(object input)
		{
  		string data = input.ToString();      // cast the input to a string

   		// replace those characters disallowed in XML documents
   		data = data.Replace("&", "&amp;");
   		data = data.Replace("\"", "&quot;");
   		data = data.Replace("'", "&apos;");
   		data = data.Replace("<", "&lt;");
   		data = data.Replace(">", "&gt;");

   		return data;
		}

}
